@extends('layout.admin',
[
'title' => 'Content Menu',
'breadcrumbs'=>[
[
'name'=> 'Content',
'url' => 'content'
]
]
])

@section('content-admin')


<div class="row">
    <!-- /# column -->
    <div class="col-lg-12">
        <div class="card alert">
            <div class="card-header">
                <h4>Content List </h4>
                <div class="card-header-right-icon">
                    <ul>
                        {{-- <li class="">
                                <form action="#" method="get">
                                    <input type="text" name="search" placeholder="Search..." class="text-dark">
                                    <button type="submit" class="btn-default"><i class="ti-search"></i></button>
                                </form>
                            </li> --}}
                        <li class=""><a href="#search"><i class="ti-search"></i></a></li>
                        <li class="doc-add"><a href="{{route('admin.content.create')}}"><i class="ti-plus"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Kategori</th>
                                <th>Title</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Author</th>
                                <th style="width:5%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($contents as $content)
                            <tr>
                                <td scope="row">{{$contents->firstItem() + $loop->index}}</td>
                                <td>{{$content->kategori}}</td>
                                <td>{{$content->title}}</td>
                                @if($content->status == 'draft')
                                <td><span class="badge badge-danger">{{$content->status}}</span></td>
                                @else
                                <td><span class="badge badge-primary">{{$content->status}}</span></td>
                                @endif
                                <td>{{$content->created_at}}</td>
                                <td class="color-primary">{{$content->user->name}}</td>
                                <td>
                                    <a href="{{route('admin.content.edit',$content->id)}}"><i class="ti-pencil"></i></a>
                                    <a href="{{ route('admin.content.destroy',$content->id) }}" onclick="event.preventDefault();
                                                  document.getElementById('destroy-form').submit();">
                                        <i class="ti-trash"></i>
                                    </a>
                                    <form id="destroy-form" action="{{route('admin.content.destroy',$content->id)}}" method="POST" class="d-none">
                                        @method("DELETE")
                                        @csrf
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{$contents->links('pagination::bootstrap-4')}}
                </div>
            </div>
        </div>
        <!-- /# card -->
    </div>
    <!-- /# column -->
</div>
<div id="search">
    <button type="button" class="close">×</button>
    <form action="#" method="GET">
        <input type="search" value="" placeholder="type keyword(s) here" />
        <button type="submit" class="btn btn-primary">Search</button>
    </form>
</div>
<div class="row">
    <div class="col-lg-12">
        <div class="footer">
            <p>This dashboard was generated on <span id="date-time"></span> <a href="#" class="page-refresh">Refresh
                    Dashboard</a></p>
        </div>
    </div>
</div>
</div>

@endsection
