@extends('layout.admin',
    [
    'title' => 'Content Menu',
    'breadcrumbs'=>[
            [
                'name'=> 'Content', 
                'url' => 'admin.content.index'
],
[
                'name'=> 'Edit', 
                'url' => 'edit'
            ]
        ]
    ])

@section('content-admin')

<div class="row">
    <div class="col-lg-12">
        <div class="card alert">
            <div class="card-header">
                <h4>Edit Content</h4>
            </div>
            <div class="card-body">
                <div class="basic-elements">
                    <form method="post" action="{{route('admin.content.update', $content->id)}}" enctype="multipart/form-data">
                        @method('PUT')
                        @csrf
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>Kategori</label>
                                    <select name="kategori" class="form-control">
                                        <option value="hikayat" {{$content->kategori == 'hikayat' ? 'selected' : ''}}>Hikayat</option>
                                        <option value="budaya" {{$content->kategori == 'budaya' ? 'selected' : ''}}>Budaya</option>
                                        <option value="tokoh" {{$content->kategori == 'tokoh' ? 'selected' : ''}}>Tokoh</option>
                                        <option value="situs" {{$content->kategori == 'situs' ? 'selected' : ''}}>Situs</option>
                                        <option value="lagu daerah" {{$content->kategori == 'lagu daerah' ? 'selected' : ''}}>Lagu Daerah</option>

                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Title</label>
                                    <input name="title" type="text" class="form-control" value="{{$content->title}}">
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label>Popular</label>
                                    <select name="isPopular" class="form-control">
                                        <option value="1"  {{$content->isPopular ? 'selected' : ''}}>Yes</option>
                                        <option value="0" {{$content->isPopular == 0 ? 'selected' : ''}}>No</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Status</label>
                                    <select name="status" class="form-control">
                                        <option value="draft" {{$content->status == "draft" ? 'selected' : ''}}>draft</option>
                                        <option value="published" {{$content->status == "published" ? 'selected' : ''}}>Published</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="thumbnail">Thumbnail</label></br>
                                    <img src="{{$highlight->thumbnail}}" alt="">
                                    <input name="thumbnail" type="file" src="" alt="">
                                    @error('thumbnail')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>Subkategori</label>
                                    <input name="subkategori" type="text" class="form-control" value="" disabled>
                                </div>
                                <div class="form-group">
                                    <label>Subtitle</label>
                                    <input name="subtitle" type="text" class="form-control" value="{{$content->subtitle}}">
                                    @error('subtitle')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label>Highlight</label>
                                    <select name="isHighlight" class="form-control">
                                        option value="1"  {{$content->isPopular ? 'selected' : ''}}>Yes</option>
                                        <option value="0" {{$content->isPopular == 0 ? 'selected' : ''}}>No</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Tags</label>
                                    <input name="tags" type="text" class="form-control" value="{{$content->tags}}" placeholder="example : news,berita,olahraga">
                                    @error('tags')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="image">Image</label></br>
                                    <small>size 800x500</small></br>
                                    <img src="{{asset('storage/').'/'.$content->headerimage}}" alt="">
                                    <input name="headerimage" type="file" src="" alt="">

                                    @error('headerimage')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="Content">Content</label>
                                    <textarea class="form-control" name="content" id="contenteditor">{{$content->content}}</textarea>
                                    @error('content')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                {{-- <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" role="switch" id="flexSwitchCheckDefault">
                                    <label class="form-check-label" for="flexSwitchCheckDefault">Seo Tag Manual</label>
                                  </div> --}}
                            </div>
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-default" type="submit">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /# row -->
@endsection

@push('after-script')
<script src="https://cdn.ckeditor.com/ckeditor5/35.4.0/classic/ckeditor.js"></script>
<script>
        ClassicEditor
          .create( document.querySelector( '#contenteditor' ),{ 
                ckfinder: {
                      uploadUrl: "{{route('admin.content.uploadeditor').'?_token='.csrf_token()}}",
                }
          } )
          .then( editor => {
                console.log( editor );
          } )
          .catch( error => {
                console.error( error );
          } );
  </script>
@endpush

@push('after-style')
    <style>
        .ck-editor__editable_inline {
            min-height: 200px;
        }
        
        .ck-editor__editable_inline * {
            color: black;
            padding-left: 10px;
        }
    </style>

@endpush
