<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Content extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];


    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function scopePublish($query)
    {
        $query->where('status', 'published');
    }

    public function getThumbnailAttribute($query)
    {
        return url('storage/' . $query);
    }

    public function getHeaderimageAttribute($query)
    {
        return url('storage/' . $query);
    }
}
