

<?php $__env->startSection('content-admin'); ?>
<div class="row">
    <!-- /# column -->
    <div class="col-lg-12">
        <div class="card alert">
            <div class="card-header">
                <h4>User List </h4>
                <div class="card-header-right-icon">
                    <ul>
                        <li class=""><a href="#search"><i class="ti-search"></i></a></li>
                        <li class="doc-add"><a href="<?php echo e(route('admin.user.create')); ?>"><i class="ti-plus"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Email</th>
                                <th>Name</th>
                                <th>Role</th>
                                <th>Point</th>
                                <th>Gender</th>
                                <th>Active</th>
                                <th class="text-center" style="width:10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td scope="row"><?php echo e($users->firstItem() + $loop->index); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e($user->name); ?> <?php echo e($user->lastname); ?></td>
                                <td><?php echo e($user->getRoleNames()[0]); ?></td>
                                <td><?php echo e($user->point); ?></td>
                                <td><?php echo e($user->gender); ?></td>
                                <td><?php echo e(($user->is_active) ? "YES" : "NO"); ?></td>
                                <td>
                                    <?php if($user->getRoleNames()[0] != 'superadmin'): ?>
                                    <a href="<?php echo e(route('admin.user.edit',$user->id)); ?>"><i class="ti-pencil"
                                            data-toggle="tooltip" data-placement="top" title="Edit User"></i></a>
                                    <a href="" onclick="event.preventDefault();
                                                  document.getElementById('destroy-form<?php echo e($user->id); ?>').submit();"
                                        data-toggle="tooltip" data-placement="top" title="Delete User">
                                        <i class="ti-trash"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.user.show',$user->id)); ?>"><i class="ti-eye"
                                            data-toggle="tooltip" data-placement="top" title="Add Question"></i></a>
                                    <form class="d-none" id="destroy-form<?php echo e($user->id); ?>"
                                        action="<?php echo e(route('admin.user.destroy',$user->id)); ?>" method="POST">
                                        <?php echo method_field("DELETE"); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($users->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
        <!-- /# card -->
    </div>
    <!-- /# column -->

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.admin',
[
'title' => 'User Menu',
'breadcrumbs'=>[
    [
    'name'=> 'User',
    'url' => 'user'
    ]
]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\sejaralokalsumut.org\resources\views/admin/user/index.blade.php ENDPATH**/ ?>