

<?php $__env->startSection('content-admin'); ?>
<div class="row">
    <!-- /# column -->
    <div class="col-lg-12">
        <div class="card alert">
            <div class="card-header">
                <h4>Question List - <?php echo e($quiz->title); ?> </h4>
                <div class="card-header-right-icon">
                    <ul>
                        <li class=""><a href="#search"><i class="ti-search"></i></a></li>
                        <li class="doc-add"><a href="<?php echo e(route('admin.question.create',$quiz->id)); ?>"><i class="ti-plus"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Question</th>
                                <th>Jawaban</th>
                                <th class="text-center" style="width:10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td scope="row"><?php echo e($questions->firstItem() + $loop->index); ?></td>
                                <td><?php echo e($question->question); ?></td>
                                <td><?php echo e($question->answer[0]->answer); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.question.edit',$question->id)); ?>"><i class="ti-pencil"
                                            data-toggle="tooltip" data-placement="top" title="Edit Quiz"></i></a>
                                    <a href="" onclick="event.preventDefault();
                                                  document.getElementById('destroy-form<?php echo e($question->id); ?>').submit();"
                                        data-toggle="tooltip" data-placement="top" title="Delete Quiz">
                                        <i class="ti-trash"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.question.show',$question->id)); ?>"><i class="ti-eye"
                                            data-toggle="tooltip" data-placement="top" title="Add Question"></i></a>
                                    <form class="d-none" id="destroy-form<?php echo e($question->id); ?>"
                                        action="<?php echo e(route('admin.question.destroy',$question->id)); ?>" method="POST">
                                        <?php echo method_field("DELETE"); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($questions->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
        <!-- /# card -->
    </div>
    <!-- /# column -->

</div>
<div id="search">
    <button type="button" class="close">×</button>
    <form method="get" action="#">
        <?php echo csrf_field(); ?>
        <input type="search" name="search" placeholder="type keyword(s) here" />
        <button class="btn btn-primary" type="submit">Search</button>
    </form>
</div>
<div class="row">
    <div class="col-lg-12">
        <div class="footer">
            <p>This dashboard was generated on <span id="date-time"></span> <a href="#" class="page-refresh">Refresh
                    Dashboard</a></p>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.admin',
[
'title' => 'Question Menu',
'breadcrumbs'=>[
    [
    'name'=> 'Quiz',
    'url' => 'admin.quiz.index',
    'id' => $quiz->id
],
[
    'name' => 'Question',
    'url' => 'Question'
]
]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\sejaralokalsumut.org\resources\views/admin/question/index.blade.php ENDPATH**/ ?>