

<?php $__env->startSection('content-admin'); ?>
<div class="row">
    <div class="col-lg-12">
        <div class="card alert">
            <form action="#" method="get">
                <div class="row">
                    <div class="col-md-3">
                        <div class="basic-form">
                            <div class="form-group">
                                <label>Title</label>
                                <input type="text" class="form-control border-none input-flat bg-ash">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="basic-form">
                            <div class="form-group">
                                <label>kategori</label>
                                <input type="text" class="form-control border-none input-flat bg-ash" placeholder="2017-2018">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="basic-form">
                            <div class="form-group">
                                <label>Type Content</label>
                                <select name="isPost" class="form-control bg-ash border-none">
                                    <option value="0">Artice</option>
                                    <option value="1">Post</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="basic-form">
                            <div class="form-group">
                                <label>Status</label>
                                <select name="isPost" class="form-control bg-ash border-none">
                                    <option value="published">Published</option>
                                    <option value="draft">Fraft</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <button class="btn btn-default btn-lg m-b-10 bg-warning border-none m-r-5 sbmt-btn" type="submit">Search</button>
            </form>
        </div>
    </div>
</div>
<div class="row">
    <!-- /# column -->
    <div class="col-lg-12">
        <div class="card alert">
            <div class="card-header">
                <h4>Content List </h4>
                <div class="card-header-right-icon">
                    <ul>
                        <li class="doc-add"><a href="<?php echo e(route('user.content.create')); ?>"><i class="ti-plus"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Post/Article</th>
                                <th>Kategori</th>
                                <th>Title</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Author</th>
                                <th class="text-center" style="width:10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td scope="row"><?php echo e($contents->firstItem() + $loop->index); ?></td>
                                <td><?php echo e($content->isPost ? 'Post' : 'article'); ?></td>
                                <td><?php echo e($content->kategori); ?></td>
                                <td><?php echo e($content->title); ?></td>
                                <?php if($content->status == 'draft'): ?>
                                <td><span class="badge badge-danger"><?php echo e($content->status); ?></span></td>
                                <?php else: ?>
                                <td><span class="badge badge-primary"><?php echo e($content->status); ?></span></td>
                                <?php endif; ?>
                                <td><?php echo e($content->created_at); ?></td>
                                <td class="color-primary"><?php echo e($content->user->name); ?></td>
                                <td>
                                    <a href="<?php echo e(route('user.content.edit',$content->id)); ?>"><i class="ti-pencil"
                                            data-toggle="tooltip" data-placement="top" title="Edit Content"></i></a>
                                    <a href="" onclick="event.preventDefault();
                                                  document.getElementById('destroy-form<?php echo e($content->id); ?>').submit();"
                                        data-toggle="tooltip" data-placement="top" title="Delete Content">
                                        <i class="ti-trash"></i>
                                    </a>
                                    <a href="<?php echo e(route('user.content.show',$content->id)); ?>"><i class="ti-eye"
                                            data-toggle="tooltip" data-placement="top" title="View Comment"></i></a>
                                    <form class="d-none" id="destroy-form<?php echo e($content->id); ?>"
                                        action="<?php echo e(route('user.content.destroy',$content->id)); ?>" method="POST">
                                        <?php echo method_field("DELETE"); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($contents->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
        <!-- /# card -->
    </div>
    <!-- /# column -->
    
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.admin',
[
'title' => 'Content Menu',
'breadcrumbs'=>[
    [
    'name'=> 'Content',
    'url' => 'content'
    ]
]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\sejaralokalsumut.org\resources\views/user/content/index.blade.php ENDPATH**/ ?>