<!DOCTYPE html>
<html lang="en" class="dark">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Panel</title>
    <link rel="apple-touch-icon" href="icon.png">
    <link rel="apple-touch-icon" href="<?php echo e(asset('images/placeholder/favicon.ico')); ?>">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('images/placeholder/favicon.ico')); ?>">

    <!-- ================= Favicon ================== -->
    <!-- Standard -->
    
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('images/placeholder/apple-touch-icon.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('images/placeholder/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/placeholder/favicon-16x16.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('images/placeholder/site.webmanifest')); ?>">
    <!-- Styles -->
    
    <link href="<?php echo e(asset('assets/css/lib/font-awesome.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/lib/themify-icons.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/lib/owl.carousel.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/lib/owl.theme.default.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/lib/weather-icons.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/lib/menubar/sidebar.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/lib/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/lib/unix.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/style.css')); ?>" rel="stylesheet">
    <?php echo $__env->yieldPushContent('after-style-admin'); ?>
</head>

<body>

    <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <div class="header">
        <div class="pull-left">
            <div class="logo"><a href="<?php echo e(route('admin.home')); ?>">
                    <!-- <img src="assets/images/logo.png" alt="" /> --><span>Sejarah Lokal Sumut</span></a></div>
            <div class="hamburger sidebar-toggle">
                <span class="line"></span>
                <span class="line"></span>
                <span class="line"></span>
            </div>
        </div>
        <div class="pull-right p-r-15">
            <ul>
                
                <li class="header-icon dib">
                    <a href="<?php echo e(route('lp-index')); ?>"><i class="ti-eye"></i></a>
                </li>
                <li class="header-icon dib"><img class="avatar-img" src="assets/images/avatar/1.jpg" alt="" /> <span
                        class="user-avatar"><?php echo e(ucfirst(auth()->user()->name)); ?> <i
                            class="ti-angle-down f-s-10"></i></span>
                    <div class="drop-down dropdown-profile">
                        <div class="dropdown-content-body">
                            <ul>
                                <li><a href="<?php echo e(route('user.home')); ?>"><i class="ti-user"></i> <span>Profile</span></a></li>
                                <li>
                                    <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                                  document.getElementById('logout-form').submit();">
                                        <i class="ti-power-off"></i>
                                        <span><?php echo e(__('Logout')); ?></span>
                                    </a></li>
                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </ul>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>
    <div class="content-wrap">
        <div class="main">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-8 p-r-0 title-margin-right">
                        <div class="page-header">
                            <div class="page-title">
                                
                            </div>
                        </div>
                    </div>
                    <!-- /# column -->
                    <div class="col-lg-4 p-l-0 title-margin-left">
                        <div class="page-header">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="<?php echo e(route('admin.home')); ?>">Dashboard</a></li>
                                    
                                    <?php if(isset($breadcrumbs)): ?>
                                    <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="<?php echo e(($key === array_key_last($breadcrumbs)) ? "active" : ""); ?>">
                                        <?php if($key === array_key_last($breadcrumbs)): ?>
                                        <?php echo e($breadcrumb['name']); ?>

                                        <?php else: ?>
                                        <?php if(isset($breadcrumb["id"])): ?>
                                        <?php $id = $breadcrumb["id"]; ?>
                                        <a href="<?php echo e(route($breadcrumb["url"],$id)); ?>"><?php echo e($breadcrumb['name']); ?></a>
                                        <?php else: ?>
                                        <a href="<?php echo e(route($breadcrumb["url"])); ?>"><?php echo e($breadcrumb['name']); ?></a>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ol>
                            </div>
                        </div>
                    </div>
                    <!-- /# column -->
                </div>
                <!-- /# row -->
                <div id="main-content">

                    <?php echo $__env->yieldContent('content-admin'); ?>

                    
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="footer">
                                <p>Copyright sejarahlokalsumut.org</p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    

    <script src="<?php echo e(asset('assets/js/lib/jquery.min.js')); ?>"></script>
    <!-- jquery vendor -->
    <script src="<?php echo e(asset('assets/js/lib/jquery.nanoscroller.min.js')); ?>"></script>
    <!-- nano scroller -->
    <script src="<?php echo e(asset('assets/js/lib/menubar/sidebar.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/preloader/pace.min.js')); ?>"></script>
    <!-- sidebar -->
    <script src="<?php echo e(asset('assets/js/lib/bootstrap.min.js')); ?>"></script>
    <!-- bootstrap -->
    <script src="<?php echo e(asset('assets/js/lib/weather/jquery.simpleWeather.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/weather/weather-init.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/circle-progress/circle-progress.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/circle-progress/circle-progress-init.js')); ?>"></script>
    
    <script src="<?php echo e(asset('assets/js/lib/sparklinechart/jquery.sparkline.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/sparklinechart/sparkline.init.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/owl-carousel/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/owl-carousel/owl.carousel-init.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/scripts.js')); ?>"></script>
    <?php echo $__env->make('sweetalert::alert', ['cdn' => "https://cdn.jsdelivr.net/npm/sweetalert2@9"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('after-script-admin'); ?>
</body>

</html>
<?php /**PATH C:\laragon\www\sejaralokalsumut.org\resources\views/layout/admin.blade.php ENDPATH**/ ?>