

<?php $__env->startSection('content-admin'); ?>
<div class="row">
    <!-- /# column -->
    <div class="col-lg-12">
        <div class="card alert">
            <div class="card-header">
                <h4>Quiz List </h4>
                <div class="card-header-right-icon">
                    <ul>
                        <li class=""><a href="#search"><i class="ti-search"></i></a></li>
                        <li class="doc-add"><a href="<?php echo e(route('admin.quiz.create')); ?>"><i class="ti-plus"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Title</th>
                                <th>Start</th>
                                <th>End</th>
                                <th>Point</th>
                                <th>Pertanyaan</th>
                                <th>Active</th>
                                <th class="text-center" style="width:10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $quizzes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quiz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td scope="row"><?php echo e($quizzes->firstItem() + $loop->index); ?></td>
                                <td><?php echo e($quiz->title); ?></td>
                                <td><?php echo e($quiz->start_date); ?></td>
                                <td><?php echo e($quiz->end_date); ?></td>
                                <td><?php echo e($quiz->point); ?></td>
                                <td><?php echo e(count($quiz->question)); ?></td>
                                <td><?php echo e(($quiz->is_active) ? "YES" : "NO"); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.quiz.edit',$quiz->id)); ?>"><i class="ti-pencil"
                                            data-toggle="tooltip" data-placement="top" title="Edit Quiz"></i></a>
                                    <a href="" onclick="event.preventDefault();
                                                  document.getElementById('destroy-form<?php echo e($quiz->id); ?>').submit();"
                                        data-toggle="tooltip" data-placement="top" title="Delete Quiz">
                                        <i class="ti-trash"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.question.index',$quiz->id)); ?>"><i class="ti-eye"
                                            data-toggle="tooltip" data-placement="top" title="Add Question"></i></a>
                                    <form class="d-none" id="destroy-form<?php echo e($quiz->id); ?>"
                                        action="<?php echo e(route('admin.quiz.destroy',$quiz->id)); ?>" method="POST">
                                        <?php echo method_field("DELETE"); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($quizzes->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
        <!-- /# card -->
    </div>
    <!-- /# column -->

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.admin',
[
'title' => 'Quiz Menu',
'breadcrumbs'=>[
    [
    'name'=> 'Quiz',
    'url' => 'quiz'
    ]
]
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\sejaralokalsumut.org\resources\views/admin/quiz/index.blade.php ENDPATH**/ ?>