<?php

use App\Http\Controllers\AboutController;
use App\Http\Controllers\CommentController;
use App\Http\Controllers\ContentController;
use App\Http\Controllers\LandingPageController;
use App\Http\Controllers\QuestionController;
use App\Http\Controllers\QuizController;
use App\Http\Controllers\User\ContentController as UserContentController;
use App\Http\Controllers\User\QuizController as UserQuizController;
use App\Http\Controllers\User\UserController as UserUserController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/about', [LandingPageController::class, 'about'])->name('about');
Route::get('/laman-sejarah/{id}', [LandingPageController::class, 'lamanSejarahDetail'])->name('lp-laman-sejarah-detail');
Route::get('/laman-sejarah', [LandingPageController::class, 'lamanSejarah'])->name('lp-laman-sejarah');


Route::get('/login', function () {
    // return view('welcome');
    return view('login');
});

Route::get('/register', function () {
    // return view('welcome');
    return view('register');
});

Auth::routes();

Route::group(['prefix' => 'admin', 'middleware' => ['auth', 'role:superadmin|admin'], 'as' => 'admin.'], function () {
    Route::get('home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::resource('user', UserController::class);
    Route::resource('about', AboutController::class);
    Route::resource('content', ContentController::class);
    Route::resource('quiz', QuizController::class);

    //question quiz admin
    Route::get('/question/{id}', [QuestionController::class, 'index'])->name('question.index');
    Route::get('/question/{id}/edit', [QuestionController::class, 'edit'])->name('question.edit');
    Route::get('/question/{id}/show', [QuestionController::class, 'show'])->name('question.show');
    Route::delete('/question/{id}', [QuestionController::class, 'destroy'])->name('question.destroy');
    Route::put('/question/{id}', [QuestionController::class, 'update'])->name('question.update');
    Route::post('/question', [QuestionController::class, 'store'])->name('question.store');
    Route::get('/question/create/{id}', [QuestionController::class, 'create'])->name('question.create');


    Route::post('/content/uploadfile', [App\Http\Controllers\ContentController::class, 'uploadfile'])->name('content.uploadeditor');
    Route::delete('comment/{id}', [App\Http\Controllers\ContentController::class, 'destroyComment'])->name('comment.destroy');

    Route::get('/static/{name}', [AboutController::class, 'static'])->name('static.index');
    Route::put('/static/{id}', [AboutController::class, 'staticUpdate'])->name('static.update');
});


Route::group(['prefix' => 'user', 'middleware' => 'auth', 'as' => 'user.'], function () {
    Route::get('home', [App\Http\Controllers\HomeController::class, 'indexuser'])->name('home');
    Route::post('/content/uploadfile', [App\Http\Controllers\ContentController::class, 'uploadfile'])->name('content.uploadeditor');
    Route::resource('content', UserContentController::class);
    Route::resource('quiz', UserQuizController::class);
    Route::delete('comment/{id}', [App\Http\Controllers\ContentController::class, 'destroyComment'])->name('comment.destroy');
    Route::get('user/{id}/edit', [UserUserController::class, 'edit'])->name('user.edit');
    Route::put('user/{id}/edit', [UserUserController::class, 'update'])->name('user.update');
});

Route::group(['middleware' => 'auth'], function () {

    Route::post('/penilaian-kesadaran-sejarah', [LandingPageController::class, 'quizSubmit'])->name('lp-penilaian-post');
    Route::get('/penilaian-kesadaran-sejarah/{id}', [LandingPageController::class, 'question'])->name('lp-question');
    Route::get('/penilaian-kesadaran-sejarah/result/{id}', [LandingPageController::class, 'quizResult'])->name('lp-penilaian-result');
    Route::post('/laman-sejarah', [LandingPageController::class, 'lamanSejarahStore'])->name('lp-post-store');
});

Route::get('/', [LandingPageController::class, 'index'])->name('lp-index');
Route::get('/search', [LandingPageController::class, 'search'])->name('lp-search');
Route::get('/penilaian-kesadaran-sejarah', [LandingPageController::class, 'quiz'])->name('lp-penilaian');
Route::get('/policy', [LandingPageController::class, 'policy'])->name('lp-policy');
Route::get('/termofuse', [LandingPageController::class, 'termofuse'])->name('lp-termofuse');
Route::get('/{category}', [LandingPageController::class, 'category'])->name('lp-kategori');
Route::get('{category}/{slug}', [LandingPageController::class, 'detail'])->name('lp-detail');
Route::post('/comment', [LandingPageController::class, 'comment'])->name('lp-post-comment');
