@extends('layout.admin',
[
'title' => 'Quiz Menu',
'breadcrumbs'=>[
    [
    'name'=> 'Quiz',
    'url' => 'quiz'
    ]
]
])

@section('content-admin')
<div class="row">
    <!-- /# column -->
    <div class="col-lg-12">
        <div class="card alert">
            <div class="card-header">
                <h4>Quiz List </h4>
                <div class="card-header-right-icon">
                    <ul>
                        <li class=""><a href="#search"><i class="ti-search"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Tanggal</th>
                                <th>Title</th>
                                <th>Point</th>
                                <th>Point Quiz</th>
                                <th>Pertanyaan</th>
                                <th>Active</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($scores as $score)
                            <tr>
                                <td scope="row">{{$scores->firstItem() + $loop->index}}</td>
                                <td>{{$score->created_at}}</td>
                                <td>{{$score->quiz->title}}</td>
                                <td>{{$score->point}}</td>
                                <td>{{$score->quiz->point}}</td>
                                <td>{{count($score->quiz->question)}}</td>
                                <td>{{($score->quiz->is_active) ? "YES" : "NO"}}</td>
                                
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{$scores->links('pagination::bootstrap-4')}}
                </div>
            </div>
        </div>
        <!-- /# card -->
    </div>
    <!-- /# column -->

</div>
@endsection
