@extends('layout.app',['title' => 'Penilaian Kesadaran Sejarah'])

@section('content')
<section class="bg-content">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!-- Breadcrumb -->
                @include('include.breadcrumb-content',['kategori' => 'penilaian-kesadaran-sejarah'])

            </div>

        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <aside class="wrapper__list__article ">
                    <h4 class="border_section">Penilaian Kesadaran Sejarah</h4>
                    <p>Dengan mengikuti quiz dibawah anda akan mendapatkan point dan ada {{count($quizzes)}} quiz yang anda bisa ikuti, jangan lupa untuk <a href="{{route('login')}}" class="text-danger"><b>Login/Register</b></a> terlebih dahulu</p>
                    @foreach($quizzes as $quiz)
                    <!-- Post Article List -->
                    <div class="card__post card__post__transition mt-30 ">
                        <div class="row">
                           
                            <div class="col-md-9 my-auto" >
                                <div class="card__post__body ">
                                    <div class="card__post__content  ">
                                        <div class="card__post__category ">
                                            Quiz Pengetahuan
                                        </div>
                                        <div class="card__post__author-info mb-2">
                                            <ul class="list-inline">
                                                <li class="list-inline-item">
                                                    <span class="text-primary">
                                                        <i class="fa fa-calendar"></i>
                                                    </span>
                                                    <span class="text-dark text-capitalize">
                                                        {{date('d',strtotime($quiz->start_date)).' - '. date('d F Y',strtotime($quiz->end_date))}}
                                                    </span>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span class="text-primary">
                                                        <i class="fa fa-question"></i>
                                                    </span>
                                                    <span class="text-dark text-capitalize">
                                                        {{count($quiz->question)}} Pertanyaan
                                                    </span>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span class="text-primary">
                                                        <i class="fa fa-star"></i>
                                                    </span>
                                                    <span class="text-dark text-capitalize">
                                                        {{$quiz->point}} Point
                                                    </span>
                                                </li>

                                            </ul>
                                        </div>
                                        <div class="card__post__title">
                                            <h5>
                                                <a href="{{route('lp-question',$quiz->id)}}">
                                                    {{$quiz->title}}
                                                </a>
                                            </h5>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-3 my-auto">
                                        <a href="{{route('lp-question',$quiz->id)}}" class="btn btn-md btn-primary text-capitalize text-left"> Mulai</a>
                            </div>
                        </div>
                    </div>
                    <hr>
                    @endforeach
                </aside>
            </div>
            @include('include.sidebar-content')
        </div>

        <!-- Pagination -->
        {{$quizzes->links('pagination::custom')}}
        <div class="pagination-area">
            <div class="pagination wow fadeIn animated" data-wow-duration="2s" data-wow-delay="0.5s"
            style="visibility: visible; animation-duration: 2s; animation-delay: 0.5s; animation-name: fadeIn;">
                {{-- <a href="#">
                    «
                </a>
                <a href="#">
                    1
                </a>
                <a class="active" href="#">
                    2
                </a>
                <a href="#">
                    3
                </a>
                <a href="#">
                    4
                </a>
                <a href="#">
                    5
                </a>

                <a href="#">
                    »
                </a> --}}
            </div>
        </div>

    </div>
</section>

@endsection