@extends('layout.app',['title' => 'Penilaian Kesadaran Sejarah'])

@section('content')
<!-- search -->
<section class="bg-content">
    <div class="container">
        <div class="row">
            <div class="col-md-8 mx-auto">
                <!-- Search result -->
                <div class="wrap__search-result">
                    <div class="wrap__search-result-keyword">
                        <h5>{{$questions[0]->quiz->title}}</h5>
                    </div>

                    <!-- Post Article List -->
                    <form action="{{route('lp-penilaian-post')}}" method="POST">
                        <input type="hidden" name="quiz_id" value="{{$questions[0]->quiz->id}}">
                        @foreach($questions as $question)
                        <input type="hidden" name="questions[]" value="{{$question->id}}">
                        <div class="card border-info mb-4 ">
                            
                            <div class="d-flex justify-content-between align-items-center card-header bg-primary text-white"
                            id="h1">
                            <span>Pertanyaan {{$loop->iteration}}</span>
                        </div>
                        <div id="q1" class="collapse show" aria-labelledby="h1">
                            <div class="card-body">
                                @if($question->headerimage)
                                <img src="{{$question->headerimage}}" alt="">
                                @endif
                                <p>{{$question->question}}</p>
                                @foreach($question->answer as $answer)
                                    @csrf
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="answer{{$question->id}}" id="answer" value="{{$answer->id}}" required>
                                        <label class="form-check-label" for="q1_r1">
                                            {{$answer->answer}}
                                        </label>
                                    </div>
                                    @endforeach
                                </div>
                                
                            </div>
                        </div>
                        @endforeach
                        <div class="text-right">
                            <button class="btn btn-primary">Submit</button>
                        </div>
                    </form>


                </div>
            </div>

        </div>
    </div>
</section>
<!-- end search -->

@endsection
