@extends('layout.app',['title' => 'Tentang kami'])

@section('content')
<section class="wrap__section bg-light">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="container">
                    <div class="title-head">
                        <div class="row justify-content-center">
                            <div class="col-md-6 col-sm-12 text-center">
                                <h3>
                                    Laman Sejarah
                                </h3>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        @foreach($contents as $content)
                        <div class="col-lg-4 mt-5">
                            <!-- Post Article -->
                            <div class="article__entry-new">
                                {{-- <div class="">
                                    life
                                </div> --}}
                                <div class="article__image articel__image__transition">
                                    <a href="{{route('lp-laman-sejarah-detail',$content->id)}}">
                                        <img src="{{$content->thumbnail}}" alt="" class="img-fluid w-100">
                                    </a>
                                </div>
                                <div class="articel__content">

                                    <div class="article__post__title">
                                        <h5><a href="{{route('lp-laman-sejarah-detail',$content->id)}}">
                                                {{$content->title}}
                                            </a>
                                        </h5>
                                        <ul class="list-inline article__post__author">
                                            <li class="list-inline-item">
                                                <span> by {{$content->user->name}}</span>
                                            </li>
                                            <li class="list-inline-item">
                                                <span>{{date('d F Y',strtotime($content->created_at))}}</span>
                                            </li>
                                        </ul>

                                    </div>
                                </div>

                            </div>
                        </div>
                        @endforeach
                        <div class="clerfix"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{$contents->links('pagination::custom')}}
    
</section>
<section class="wrapper__section p-0">
    <div class="wrapper__section__components">
        <footer>
            <div class="wrapper__footer bg-white">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-6">
                            <div class="wrapper__footer-logo text-center">
                                <p>
                                    Bagikan pengalaman sejarah mu sendiri
                                </p>
                                @if(auth()->user() != null)
                                <p class="mb-0">
                                    <button class="btn btn-md btn-lg btn-primary" data-toggle="modal" data-target="#exampleModal">
                                        <i class="fa fa-1x fa-plus text-white"></i>
                                    </button>
                                </p>
                                @else
                                <p>Jangan lupa untuk <a href="{{route('login')}}" class="text-danger"><b>Login/Register</b></a> terlebih dahulu</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </footer>
    </div>
</section>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Post Pengalaman Sejarah Mu</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
            <div class="basic-elements">
                <form method="post" action="{{route('lp-post-store')}}" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label>Caption</label></br>
                                <small>* max 255 Char</small>
                                <textarea name="title" type="text" class="form-control" value="" cols="30" rows="10" maxlength="255">{{old('title')}}</textarea>
                                @error('title')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            

                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="thumb">Image 1</label></br>
                                <input name="thumb" type="file" src="" alt="" value="{{old('thumb')}}">
                                @error('thumb')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="image">Image 2</label></br>
                                <input name="image" type="file" src="" alt="" value="{{old('image')}}">
                                @error('image')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Share</button>
            </form>
        </div>
      </div>
    </div>
  </div>

@endsection


