@extends('layout.app',['title' => 'Tentang kami'])

@section('content')
<section class="wrap__section bg-light">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="slider-hero">
                    <div class="featured-carousel owl-carousel">
                        <div class="item">
                            <div class="work">
                                <div class="img d-flex align-items-center justify-content-center"
                                    style="background-image: url({{$content->thumbnail}});">
                                    <div class="text text-center">
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if(explode('/', $content->headerimage)[4] != "-")
                        <div class="item">
                            <div class="work">
                                <div class="img d-flex align-items-center justify-content-center"
                                    style="background-image: url({{$content->headerimage}});">
                                    <div class="text text-center">
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <div class="my-5 text-center">
                        <ul class="thumbnail">
                            <li class="active img">
                                <a href="#">    
                                    <img src="{{$content->thumbnail}}" alt="Image" class="img-fluid">
                                </a>
                            </li>
                            @if(explode('/', $content->headerimage)[4] != "-")
                            <li>
                                <a href="#">    
                                    <img src="{{$content->headerimage}}" alt="Image" class="img-fluid">
                                </a>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-md-8">
                <ul class="list-inline">
                    <li class="list-inline-item">

                        <span class="text-dark text-capitalize">
                            
                            {{$content->user->name}}
                        </span>
                    </li>
                    <li class="list-inline-item">

                        <span class="text-dark text-capitalize">
                            {{date('d F Y',strtotime($content->created_at))}}
                           
                        </span>
                    </li>
                </ul>
                <p>{{$content->title}}</p>
            </div>
        </div>
        <hr>
        <div class="row justify-content-center">
            <div class="col-md-8">
                @if(isset($data['comments']))
                <div id="comments" class="comments-area">
                    <h3 class="comments-title">{{count($data['comments'])}} Comments:</h3>

                    <ol class="comment-list">
                        @foreach($data['comments'] as $comment)
                        <li class="comment">
                            <aside class="comment-body">
                                <div class="comment-meta">
                                    <div class="comment-author vcard">
                                        @if($comment->user)
                                        <img src="{{(count(explode('/',$comment->user->image)) != 4) ?$comment->user->image: asset('images/placeholder/default-pp.png')}}"
                                            class="avatar rounded-circle" alt="image">
                                        @else
                                        <img src="{{asset('images/placeholder/default-pp.png')}}"
                                            class="avatar rounded-circle" alt="image">
                                        @endif
                                        <b
                                            class="fn">{{$comment->user ? ucfirst($comment->user->name) : ucfirst($comment->guest) ."-guest"}}</b>
                                        <span class="says">says:</span>
                                    </div>

                                    <div class="comment-metadata">
                                        <a href="#">
                                            <span> {{date('d F Y h:m a',strtotime($comment->created_at))}}</span>
                                        </a>
                                    </div>
                                </div>

                                <div class="comment-content">
                                    <p>{{$comment->comment}}
                                    </p>
                                </div>

                                <div class="reply">
                                    <a href="" data-id="{{$comment->id}}" data-comment="{{$comment->comment}}"
                                        onclick="event.preventDefault();"
                                        class="comment-reply-link reply-button">Reply</a>
                                </div>
                            </aside>
                            @if($comment->reply)
                            @foreach($comment->reply as $reply)
                            <ol class="children">
                                <li class="comment">
                                    <aside class="comment-body">
                                        <div class="comment-meta">
                                            <div class="comment-author vcard">
                                                @if($reply->user)
                                                <img src="{{(count(explode('/',$reply->user->image)) != 4) ?$reply->user->image: asset('images/placeholder/default-pp.png')}}"
                                                    class="avatar rounded-circle" alt="image">
                                                @else
                                                <img src="{{asset('images/placeholder/default-pp.png')}}"
                                                    class="avatar rounded-circle" alt="image">
                                                @endif
                                                <b
                                                    class="fn">{{$reply->user ? ucfirst($reply->user->name) : ucfirst($reply->guest)."-guest"}}</b>
                                                <span class="says">says:</span>
                                            </div>

                                            <div class="comment-metadata">
                                                <a href="#">
                                                    <span> {{date('d F Y h:m a',strtotime($reply->created_at))}}</span>
                                                </a>
                                            </div>
                                        </div>

                                        <div class="comment-content">
                                            <p>{{$reply->comment}}
                                            </p>
                                        </div>
                                    </aside>
                                </li>
                            </ol>
                            @endforeach
                            @endif
                        </li>
                        @endforeach
                    </ol>

                    <div class="comment-respond">
                        <h3 class="comment-reply-title">Leave a Reply</h3>

                        <form class="comment-form" action="{{route('lp-post-comment')}}" method="POST">
                            @csrf
                            <input type="hidden" name="comment_id" id="comment_id">
                            <input type="hidden" name="content_id" id="content_id" value="{{$content->id}}">
                            <input type="hidden" name="user_id" id="user_id"
                                value="{{auth()->user() !== null ? auth()->user()->id : ''}}">
                            <p class="comment-notes">
                                <span id="email-notes">Your email address will not be published.</span>
                                Required fields are marked
                                <span class="required">*</span>
                            </p>
                            <p class="comment-form-comment">
                                <label for="reply-content" id="reply-label"></label>
                                <span name="replycontent" id="reply-content" class="font-italic" disabled></span>
                            </p>
                            <p class="comment-form-comment">
                                <label for="comment">Comment</label>
                                <textarea name="comment" id="comment" cols="45" rows="5" maxlength="65525"
                                    required="required">{{old('comment')}}</textarea>
                                @error('comment')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </p>
                            @if(auth()->user() !== null)
                            <input type="text" id="author" name="guest" value="null" hidden>
                            <input type="text" id="guest_email" name="guest_email" value="null" hidden>

                            @else
                            <p class="comment-form-author">
                                <label>Name <span class="required">*</span></label>
                                <input type="text" id="author" name="guest" required="required"
                                    value="{{old('guest')}}">
                                @error('guest')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </p>
                            <p class="comment-form-email">
                                <label for="email">Email <span class="required">*</span></label>
                                <input type="email" id="guest_email" name="guest_email" required="required"
                                    value="{{old('guest_email')}}">
                                @error('guest_email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </p>
                            @endif
                            <p class="form-submit">
                                <input type="submit" id="submit" class="submit" value="Post Comment">
                            </p>
                        </form>
                    </div>
                </div>
                @else
                <div id="comments" class="comments-area">
                    <h3 class="comments-title">Be the first to join this article</h3>

                    <ol class="comment-list">

                    </ol>

                    <div class="comment-respond">
                        <h3 class="comment-reply-title">Leave a Reply</h3>

                        <form class="comment-form">
                            <p class="comment-notes">
                                <span id="email-notes">Your email address will not be published.</span>
                                Required fields are marked
                                <span class="required">*</span>
                            </p>
                            <p class="comment-form-comment">
                                <label for="comment">Comment</label>
                                <textarea name="comment" id="comment" cols="45" rows="5" maxlength="65525"
                                    required="required"></textarea>
                            </p>
                            <p class="comment-form-author">
                                <label>Name <span class="required">*</span></label>
                                <input type="text" id="author" name="name" required="required">
                            </p>
                            <p class="comment-form-email">
                                <label for="email">Email <span class="required">*</span></label>
                                <input type="email" id="email" name="email" required="required">
                            </p>
                            <p class="form-submit">
                                <input type="submit" name="submit" id="submit" class="submit" value="Post Comment">
                            </p>
                        </form>
                    </div>
                </div>
                @endif
            </div>

        </div>
        
    </div>

</section>


@endsection

@push('after-script')
<script>
    $('.reply-button').click(function(){
        $("#reply-content").empty()  
        $("#reply-label").empty()  
        const comment = $(this).data('comment');
        const id = $(this).data('id');

        $("#reply-label").html("Reply this comment :")   
        $("#reply-content").html(comment)  
        $("#comment_id").val(id)   
    })
    </script>
<script src="{{asset('js/bootstrap.min.js')}}"></script>
<script src="{{asset('js/owl.carousel.min.js')}}"></script>
<script src="{{asset('js/main.js')}}"></script>

@endpush

@push('after-style')
<link rel="stylesheet" href="{{asset('css/owl.carousel.min.css')}}">
<link rel="stylesheet" href="{{asset('css/owl.theme.default.min.css')}}">
<link rel="stylesheet" href="{{asset('css/style-image.css')}}">

@endpush
