@extends('layout.app',['title'=>'Halaman Utama','description' => 'Sejarah lokal sumatera utara dengan kategori hikayat, budaya, tokoh, situs, lagu daerah, laman sejarah  dan kesadaran penilaian terhadap sejarah'])

@section('content')

<!-- Popular news -->
<section class="bg-content">
    <!-- Popular news  header-->
    <div class="popular__news-header">
        <div class="container">
            <div class="row no-gutters">
                <div class="col-md-8 ">
                    <div class="card__post-carousel">
                        @foreach($data['highlight'] as $highlight)
                        <div class="item">
                            <!-- Post Article -->
                            <div class="card__post">
                                <div class="card__post__body">
                                    <a href="{{$highlight->slug}}">
                                        <img src="{{$highlight->thumbnail}}" class="img-fluid" alt="">
                                    </a>
                                    <div class="card__post__content bg__post-cover">
                                        <div class="card__post__category">
                                            {{$highlight->kategori}}
                                        </div>
                                        <div class="card__post__title">
                                            <h2>
                                                <a href="{{$highlight->slug}}">
                                                    {{$highlight->title}}
                                                </a>
                                            </h2>
                                        </div>
                                        <div class="card__post__author-info">
                                            <ul class="list-inline">
                                                <li class="list-inline-item">
                                                    <a href="#">
                                                        by {{$highlight->user->name}}
                                                    </a>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span>
                                                        {{date('d F Y',strtotime($highlight->created_at))}}
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                        @endforeach
                        {{-- <div class="item">
                            <!-- Post Article -->
                            <div class="card__post">
                                <div class="card__post__body">
                                    <a href="./card-article-detail-v1.html">
                                        <img src="images/placeholder/800x600.jpg" class="img-fluid" alt="">
                                    </a>
                                    <div class="card__post__content bg__post-cover">
                                        <div class="card__post__category">
                                            covid-19
                                        </div>
                                        <div class="card__post__title">
                                            <h2>
                                                <a href="#">
                                                    Global solidarity to fight COVID-19, and indonesia stay safe and
                                                    health
                                                </a>
                                            </h2>
                                        </div>
                                        <div class="card__post__author-info">
                                            <ul class="list-inline">
                                                <li class="list-inline-item">
                                                    <a href="#">
                                                        by david hall
                                                    </a>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span>
                                                        Descember 09, 2016
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div> --}}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="popular__news-right">
                        <!-- Post Article -->
                        @foreach($data['highlight2'] as $highlight)

                        <div class="card__post ">
                            <div class="card__post__body card__post__transition">
                                <a href="{{$highlight->slug}}">
                                    <img src="{{$highlight->thumbnail}}" class="img-fluid" alt="">
                                </a>
                                <div class="card__post__content bg__post-cover">
                                    <div class="card__post__category">
                                        {{$highlight->kategori}}
                                    </div>
                                    <div class="card__post__title">
                                        <h5>
                                            <a href="{{$highlight->slug}}">
                                                {{$highlight->title}}</a>
                                        </h5>
                                    </div>
                                    <div class="card__post__author-info">
                                        <ul class="list-inline">
                                            <li class="list-inline-item">
                                                <a href="./card-article-detail-v1.html">
                                                    by {{$highlight->user->name}}
                                                </a>
                                            </li>
                                            <li class="list-inline-item">
                                                <span>
                                                    {{date('d F Y',strtotime($highlight->created_at))}}
                                                </span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Popular news header-->
    <!-- Popular news carousel -->
  
    <!-- End Popular news carousel -->
</section>
<!-- End Popular news -->

<!-- Popular news category -->
<section class="pt-0 bg-content">
    <div class="popular__section-news">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-lg-8">
                    <div class="wrapper__list__article">
                        <h4 class="border_section">Hikayat Sumatera Utara</h4>
                    </div>
                    <div class="row ">
                        @foreach($data['hikayat']  as $hikayat)
                        <div class="col-sm-12 col-md-6 mb-4">
                            <!-- Post Article -->
                            <div class="card__post ">
                                <div class="card__post__body card__post__transition">
                                    <a href="{{$hikayat->slug}}">
                                        <img src="{{$hikayat->thumbnail}}" class="img-fluid" alt="">
                                    </a>
                                    <div class="card__post__content bg__post-cover">
                                        <div class="card__post__category">
                                            {{$hikayat->kategori}}
                                        </div>
                                        <div class="card__post__title">
                                            <h5>
                                                <a href="{{$hikayat->slug}}">
                                                    {{$hikayat->title}}
                                                </a>
                                            </h5>
                                        </div>
                                        <div class="card__post__author-info">
                                            <ul class="list-inline">
                                                <li class="list-inline-item">
                                                    <a href="./card-article-detail-v1.html">
                                                        by {{$hikayat->user->name}}
                                                    </a>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span>
                                                        {{date('d F Y',strtotime($hikayat->created_at))}}
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="row ">
                        <div class="col-sm-12 col-md-6">
                            <div class="wrapp__list__article-responsive">
                                @foreach($data['hikayat2']  as $hikayat)

                                <div class="mb-3">
                                    <!-- Post Article -->
                                    <div class="card__post card__post-list">
                                        <div class="image-sm">
                                            <a href="{{$hikayat->slug}}">
                                                <img src="{{$hikayat->thumbnail}}" class="img-fluid" alt="">
                                            </a>
                                        </div>


                                        <div class="card__post__body ">
                                            <div class="card__post__content">

                                                <div class="card__post__author-info mb-2">
                                                    <ul class="list-inline">
                                                        <li class="list-inline-item">
                                                            <span class="text-primary">
                                                                by {{$hikayat->user->name}}
                                                            </span>
                                                        </li>
                                                        <li class="list-inline-item">
                                                            <span class="text-dark text-capitalize">
                                                                {{date('d F Y',strtotime($hikayat->created_at))}}
                                                            </span>
                                                        </li>

                                                    </ul>
                                                </div>
                                                <div class="card__post__title">
                                                    <h6>
                                                        <a href="{{$hikayat->slug}}">
                                                            {{$hikayat->title}}
                                                        </a>
                                                    </h6>
                                                    

                                                </div>

                                            </div>


                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>


                <div class="col-md-12 col-lg-4">
                    <aside class="wrapper__list__article">
                        <h4 class="border_section">popular post</h4>
                        <div class="wrapper__list-number">

                            <!-- List Article -->
                            @foreach($data['popular']  as $popular)
                            <div class="card__post__list">
                                <div class="list-number">
                                    <span>
                                        {{$loop->iteration}}
                                    </span>
                                </div>
                                <a href="#" class="category">
                                    {{$popular->kategori}}
                                </a>
                                <ul class="list-inline">
                                    <li class="list-inline-item">

                                        <h5>
                                            <a href="{{$popular->slug}}">
                                                {{$popular->title}}

                                            </a>
                                        </h5>
                                    </li>
                                </ul>

                            </div>
                            @endforeach
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </div>

    <!-- Post news carousel -->
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <aside class="wrapper__list__article">
                    <h4 class="border_section">Budaya</h4>
                </aside>
            </div>
            <div class="col-md-12">

                <div class="article__entry-carousel">
                    @foreach($data['kategori']  as $budaya)
                    @if($budaya->kategori == 'Budaya')
                    <div class="item">
                        <!-- Post Article -->
                        <div class="article__entry">
                            <div class="article__image">
                                <a href="{{$budaya->slug}}">
                                    <img src=" {{$budaya->thumbnail}}" alt="" class="img-fluid">
                                </a>
                            </div>
                            <div class="article__content">
                                <ul class="list-inline">
                                    <li class="list-inline-item">
                                        <span class="text-primary">
                                            by {{$budaya->user->name}}
                                        </span>
                                    </li>
                                    <li class="list-inline-item">
                                        <span>
                                            {{date('d F Y',strtotime($budaya->created_at))}}
                                        </span>
                                    </li>

                                </ul>
                                <h5>
                                    <a href="{{$budaya->slug}}">
                                        {{$budaya->title}}
                                    </a>
                                </h5>

                            </div>
                        </div>
                    </div>
                    @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <!-- End Popular news category -->


    <!-- Popular news category -->
    <div class="mt-4">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <aside class="wrapper__list__article mb-0">
                        <h4 class="border_section">Tokoh</h4>
                        <div class="row">
                            @foreach($data['kategori']  as $tokoh)
                            @if($tokoh->kategori == 'Tokoh')
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <!-- Post Article -->
                                    <div class="article__entry">
                                        <div class="article__image">
                                            <a href="{{$tokoh->slug}}">
                                                <img src="{{$tokoh->thumbnail}}" alt="" class="img-fluid">
                                            </a>
                                        </div>
                                        <div class="article__content">
                                            <ul class="list-inline">
                                                <li class="list-inline-item">
                                                    <span class="text-primary">
                                                        by {{$tokoh->user->name}}
                                                    </span>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span>
                                                        {{date('d F Y',strtotime($tokoh->created_at))}}
                                                    </span>
                                                </li>

                                            </ul>
                                            <h5>
                                                <a href="{{$tokoh->slug}}">
                                                    {{$tokoh->title}}
                                                </a>
                                            </h5>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                            @endforeach
                        </div>
                    </aside>
                </div>

                <div class="col-md-4">
                    <div class="sticky-top">
                        <aside class="wrapper__list__article">
                            <h4 class="border_section">
                                Latest post</h4>
                            <div class="wrapper__list__article-small">

                                <!-- Post Article -->
                                @foreach($data['latest']  as $latest)

                                <div class="article__entry">
                                    <div class="article__image">
                                        <a href="{{$latest->slug}}">
                                            <img src="{{$latest->thumbnail}}" alt="" class="img-fluid">
                                        </a>
                                    </div>
                                    <div class="article__content">
                                        <div class="article__category">
                                            {{$latest->kategori}}
                                        </div>
                                        <ul class="list-inline">
                                            <li class="list-inline-item">
                                                <span class="text-primary">
                                                    by {{$latest->user->name}}
                                                </span>
                                            </li>
                                            <li class="list-inline-item">
                                                <span class="text-dark text-capitalize">
                                                    {{date('d F Y',strtotime($latest->created_at))}}
                                                </span>
                                            </li>

                                        </ul>
                                        <h5>
                                            <a href="{{$latest->slug}}">
                                                {{$latest->title}}
                                            </a>
                                        </h5>
                                        <p>
                                            {{$latest->subtitle}}
                                        </p>
                                        <a href="{{$latest->slug}}" class="btn btn-outline-primary mb-4 text-capitalize"> read
                                            more</a>
                                    </div>
                                </div>
                                @endforeach
                                @foreach($data['latest2']  as $latest)
                                <div class="mb-3">
                                    <!-- Post Article -->
                                    <div class="card__post card__post-list">
                                        <div class="image-sm">
                                            <a href="{{$latest->slug}}">
                                                <img src="{{$latest->thumbnail}}" class="img-fluid" alt="">
                                            </a>
                                        </div>


                                        <div class="card__post__body ">
                                            <div class="card__post__content">

                                                <div class="card__post__author-info mb-2">
                                                    <ul class="list-inline">
                                                        <li class="list-inline-item">
                                                            <span class="text-primary">
                                                                by {{$latest->user->name}}
                                                            </span>
                                                        </li>
                                                        <li class="list-inline-item">
                                                            <span class="text-dark text-capitalize">
                                                                {{date('d F Y',strtotime($latest->created_at))}}
                                                            </span>
                                                        </li>

                                                    </ul>
                                                </div>
                                                <div class="card__post__title">
                                                    <h6>
                                                        <a href="{{$latest->slug}}">
                                                            {{$latest->title}}
                                                        </a>
                                                    </h6>
                                                    <p class="d-none d-lg-block d-xl-block">
                
                                                </div>

                                            </div>


                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </aside>

                        {{-- <aside class="wrapper__list__article">
                            <h4 class="border_section">newsletter</h4>
                            <!-- Form Subscribe -->
                            <div class="widget__form-subscribe bg__card-shadow">
                                <h6>
                                    The most important world news and events of the day.
                                </h6>
                                <p><small>Get magzrenvi daily newsletter on your inbox.</small></p>
                                <div class="input-group ">
                                    <input type="text" class="form-control" placeholder="Your email address">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button">sign up</button>
                                    </div>
                                </div>
                            </div>
                        </aside> --}}
                    </div>
                </div>

                <div class="clearfix"></div>
            </div>
        </div>
    </div>
</section>
<!-- End Popular news category -->

@endsection
