@extends('layout.app',
[
    'title' => $content->title,
    'tagTitle' => $content->tagtitle,
    'tags' => $content->tags,
    'tagDescription' => $content->tagdescription,
    'tagUrl' => $content->tagurl,
    'tagSitename' => $content->tagsitename,
    'tagImage' => $content->tagimage,
    'tagType' => $content->tagtype,
]
)

@section('content')
<section class="pb-80 bg-content">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!-- breaddcrumb -->
                <!-- Breadcrumb -->
                @include('include.breadcrumb-content',['kategori' => $content->kategori,'article' => 'article'])
                <!-- end breadcrumb -->
            </div>
            <div class="col-md-8">
                <!-- content article detail -->
                <!-- Article Detail -->
                <div class="wrap__article-detail">
                    <div class="wrap__article-detail-title">
                        <h1>
                            {{ucwords($content->title)}}
                        </h1>
                        <h3>
                            {{ucfirst($content->subtitle)}}
                        </h3>
                    </div>
                    <hr>
                    <div class="wrap__article-detail-info">
                        <ul class="list-inline">
                            {{-- <li class="list-inline-item">
                                <figure class="image-profile">
                                    <img src="images/placeholder/logo.jpg" alt="">
                                </figure>
                            </li> --}}
                            <li class="list-inline-item">

                                <span>
                                    by
                                </span>
                                <a href="#">
                                    {{$content->user->name}},
                                </a>
                            </li>
                            <li class="list-inline-item">
                                <span class="text-dark text-capitalize ml-1">
                                    {{date('d F Y',strtotime($content->created_at))}}
                                </span>
                            </li>
                            <li class="list-inline-item">
                                <span class="text-dark text-capitalize">
                                    in
                                </span>
                                <a href="#">
                                    {{$content->kategori}}
                                </a>


                            </li>
                        </ul>
                    </div>

                    <div class="wrap__article-detail-image mt-4">
                        <figure>
                            <img src="{{$content->headerimage}}" alt="" class="img-fluid">
                        </figure>
                    </div>
                    <div class="wrap__article-detail-content">
                        <div class="total-views">
                            <div class="total-views-read">
                                @if($content->counter > 1000)
                                {{($content->counter) ? number_format($content->counter/1000,1) . 'K' : "-"}}
                                @else
                                {{($content->counter) ? $content->counter : "-"}}
                                @endif
                                <span>
                                    views
                                </span>
                            </div>


                            <ul class="list-inline">
                                <span class="share">share on:</span>
                                <li class="list-inline-item">
                                    <a class="btn btn-social-o facebook" href="https://www.facebook.com/sharer/sharer.php?u={{url($content->slug)}}" target="__blank">
                                        <i class="fa fa-facebook-f"></i>
                                        <span>facebook</span>
                                    </a>

                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-social-o twitter" href="https://twitter.com/share?url={{url($content->slug)}}" target="__blank">
                                        <i class="fa fa-twitter"></i>
                                        <span>twitter</span>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-social-o whatsapp" data-action="share/whatsapp/share" href="https://api.whatsapp.com/send?text={{url($content->slug)}}" target="__blank">
                                        <i class="fa fa-whatsapp"></i>
                                        <span>whatsapp</span>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn btn-social-o telegram" href="https://telegram.me/share/url?url={{url($content->slug)}}&text=Share artikel - {{$content->title}}" target="__blank">
                                        <i class="fa fa-telegram"></i>
                                        <span>telegram</span>
                                    </a>
                                </li>

                            </ul>
                        </div>
                        <p class="has-drop-cap-fluid">
                            {!! $content->content !!}
                        </p>
                    </div>


                </div>
                <!-- end content article detail -->

                <!-- tags -->
                <!-- News Tags -->
                <div class="blog-tags">
                    <ul class="list-inline">
                        <li class="list-inline-item">
                            <i class="fa fa-tags">
                            </i>
                        </li>
                        @php
                        $tags = explode(",",$content->tags);
                        @endphp
                        @foreach($tags as $tag)
                        <li class="list-inline-item">
                            <a href="#">
                                #{{$tag}}
                            </a>
                        </li>
                        @endforeach
                    </ul>
                </div>
                <!-- end tags-->

                <!-- authors-->
                <!-- Profile author -->
                <div class="wrap__profile">
                    <div class="wrap__profile-author">
                        <figure>
                            <img src="{{(count(explode('/',$content->user->image)) != 4) ?$content->user->image: asset('images/placeholder/default-pp.png')}}" style="width:80px" width="80" height="80" alt="" class="img-thumbnail rounded-circle">
                        </figure>
                        <div class="wrap__profile-author-detail">
                            <div class="wrap__profile-author-detail-name">author</div>
                            <h4>{{$content->user->name}} {{$content->user->lastname}}</h4>
                            <p>{{$content->user->description}}</p>
                            <ul class="list-inline">
                                <li class="list-inline-item">
                                    <a href="{{$content->user->facebook ?: '#'}}" class="btn btn-social btn-social-o facebook ">
                                        <i class="fa fa-facebook"></i>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="{{$content->user->twitter ?: '#'}}" class="btn btn-social btn-social-o twitter ">
                                        <i class="fa fa-twitter"></i>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="{{$content->user->instagram ?: '#'}}" class="btn btn-social btn-social-o instagram ">
                                        <i class="fa fa-instagram"></i>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="{{$content->user->telegram ?: '#'}}" class="btn btn-social btn-social-o telegram ">
                                        <i class="fa fa-telegram"></i>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a href="{{$content->user->linkeind ?: '#'}}" class="btn btn-social btn-social-o linkedin ">
                                        <i class="fa fa-linkedin"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- end author-->

                <!-- comment -->
                <!-- Comment  -->
                @if(isset($data['comments']))
                <div id="comments" class="comments-area">
                    <h3 class="comments-title">{{count($data['comments'])}} Comments:</h3>

                    <ol class="comment-list">
                        @foreach($data['comments'] as $comment)
                        <li class="comment">
                            <aside class="comment-body">
                                <div class="comment-meta">
                                    <div class="comment-author vcard">
                                        @if($comment->user)
                                        <img src="{{(count(explode('/',$comment->user->image)) != 4) ?$comment->user->image: asset('images/placeholder/default-pp.png')}}" class="avatar rounded-circle" alt="image">
                                        @else
                                        <img src="{{asset('images/placeholder/default-pp.png')}}" class="avatar rounded-circle" alt="image">
                                        @endif
                                        <b class="fn">{{$comment->user ? ucfirst($comment->user->name) : ucfirst($comment->guest) ."-guest"}}</b>
                                        <span class="says">says:</span>
                                    </div>

                                    <div class="comment-metadata">
                                        <a href="#">
                                            <span> {{date('d F Y h:m a',strtotime($comment->created_at))}}</span>
                                        </a>
                                    </div>
                                </div>

                                <div class="comment-content">
                                    <p>{{$comment->comment}}
                                    </p>
                                </div>

                                <div class="reply">
                                    <a href="" data-id="{{$comment->id}}" data-comment="{{$comment->comment}}" onclick="event.preventDefault();"  class="comment-reply-link reply-button">Reply</a>
                                </div>
                            </aside>
                            @if($comment->reply)
                            @foreach($comment->reply as $reply)
                            <ol class="children">
                                <li class="comment">
                                    <aside class="comment-body">
                                        <div class="comment-meta">
                                            <div class="comment-author vcard">
                                                @if($reply->user)
                                                <img src="{{(count(explode('/',$reply->user->image)) != 4) ?$reply->user->image: asset('images/placeholder/default-pp.png')}}" class="avatar rounded-circle" alt="image">
                                                @else
                                                <img src="{{asset('images/placeholder/default-pp.png')}}" class="avatar rounded-circle" alt="image">
                                                @endif
                                                <b class="fn">{{$reply->user ? ucfirst($reply->user->name) : ucfirst($reply->guest)."-guest"}}</b>
                                                <span class="says">says:</span>
                                            </div>
        
                                            <div class="comment-metadata">
                                                <a href="#">
                                                    <span> {{date('d F Y h:m a',strtotime($reply->created_at))}}</span>
                                                </a>
                                            </div>
                                        </div>
        
                                        <div class="comment-content">
                                            <p>{{$reply->comment}}
                                            </p>
                                        </div>
                                    </aside>
                                </li>
                            </ol>
                            @endforeach
                            @endif
                        </li>
                        @endforeach
                    </ol>

                    <div class="comment-respond">
                        <h3 class="comment-reply-title">Leave a Reply</h3>

                        <form class="comment-form" action="{{route('lp-post-comment')}}" method="POST">
                            @csrf
                            <input type="hidden" name="comment_id" id="comment_id">
                            <input type="hidden" name="content_id" id="content_id" value="{{$content->id}}">
                            <input type="hidden" name="user_id" id="user_id" value="{{auth()->user() !== null ? auth()->user()->id : ''}}">
                            <p class="comment-notes">
                                <span id="email-notes">Your email address will not be published.</span>
                                Required fields are marked
                                <span class="required">*</span>
                            </p>
                            <p class="comment-form-comment">
                                <label for="reply-content" id="reply-label"></label>
                                <span name="replycontent" id="reply-content" class="font-italic" disabled></span>
                            </p>
                            <p class="comment-form-comment">
                                <label for="comment">Comment</label>
                                <textarea name="comment" id="comment" cols="45" rows="5" maxlength="65525"
                                    required="required">{{old('comment')}}</textarea>
                                    @error('comment')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                            </p>
                            @if(auth()->user() !== null)
                            <input type="text" id="author" name="guest" value="null" hidden>
                            <input type="text" id="guest_email" name="guest_email" value="null" hidden>

                            @else
                            <p class="comment-form-author">
                                <label>Name <span class="required">*</span></label>
                                <input type="text" id="author" name="guest" required="required" value="{{old('guest')}}">
                                @error('guest')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                            </p>
                            <p class="comment-form-email">
                                <label for="email">Email <span class="required">*</span></label>
                                <input type="email" id="guest_email" name="guest_email" required="required" value="{{old('guest_email')}}">
                                @error('guest_email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                            </p>
                            @endif
                            <p class="form-submit">
                                <input type="submit" id="submit" class="submit" value="Post Comment">
                            </p>
                        </form>
                    </div>
                </div>
                @else
                <div id="comments" class="comments-area">
                    <h3 class="comments-title">Be the first to join this article</h3>

                    <ol class="comment-list">
                        
                    </ol>

                    <div class="comment-respond">
                        <h3 class="comment-reply-title">Leave a Reply</h3>

                        <form class="comment-form">
                            <p class="comment-notes">
                                <span id="email-notes">Your email address will not be published.</span>
                                Required fields are marked
                                <span class="required">*</span>
                            </p>
                            <p class="comment-form-comment">
                                <label for="comment">Comment</label>
                                <textarea name="comment" id="comment" cols="45" rows="5" maxlength="65525"
                                    required="required"></textarea>
                            </p>
                            <p class="comment-form-author">
                                <label>Name <span class="required">*</span></label>
                                <input type="text" id="author" name="name" required="required">
                            </p>
                            <p class="comment-form-email">
                                <label for="email">Email <span class="required">*</span></label>
                                <input type="email" id="email" name="email" required="required">
                            </p>
                            <p class="form-submit">
                                <input type="submit" name="submit" id="submit" class="submit" value="Post Comment">
                            </p>
                        </form>
                    </div>
                </div>
                @endif
                <!-- Comment -->
                <!-- end comment -->
                {{-- <div class="row">
                    <div class="col-md-6">
                        <div class="single_navigation-prev">
                            <a href="#">
                                <span>previous post</span>
                                Lorem ipsum, dolor sit amet consectetur adipisicing elit. Rem, similique.
                            </a>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="single_navigation-next text-left text-md-right">
                            <a href="#">
                                <span>next post</span>
                                Lorem ipsum, dolor sit amet consectetur adipisicing elit. Perferendis, nesciunt.
                            </a>
                        </div>
                    </div>
                </div> --}}
                <div class="clearfix"></div>

                <div class="related-article">
                    <h4>
                        you may also like
                    </h4>

                    <div class="article__entry-carousel-three">
                        @foreach($data['kategori'] as $kategori)

                        <div class="item">
                            <!-- Post Article -->
                            <div class="article__entry">
                                <div class="article__image">
                                    <a href="{{url('').'/'.$kategori->slug}}">
                                        <img src="{{$kategori->thumbnail}}" alt="" class="img-fluid">
                                    </a>
                                </div>
                                <div class="article__content">
                                    <ul class="list-inline">
                                        <li class="list-inline-item">
                                            <span class="text-primary">
                                                by {{$kategori->user->name}}
                                            </span>
                                        </li>
                                        <li class="list-inline-item">
                                            <span>
                                                {{date('d F Y',strtotime($kategori->created_at))}}
                                            </span>
                                        </li>

                                    </ul>
                                    <h5>
                                        <a href="{{url('').'/'.$kategori->slug}}">
                                            {{$kategori->title}}
                                        </a>
                                    </h5>

                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>

            </div>
            @include('include.sidebar-content')
            
        </div>
    </div>
</section>

@endsection
@push('after-script')
<script>
    $('.reply-button').click(function(){
        $("#reply-content").empty()  
        $("#reply-label").empty()  
        const comment = $(this).data('comment');
        const id = $(this).data('id');

        $("#reply-label").html("Reply this comment :")   
        $("#reply-content").html(comment)  
        $("#comment_id").val(id)   
    })
</script>
@endpush