@extends('layout.admin',
[
'title' => 'Content Menu',
'breadcrumbs'=>[
    [
    'name'=> 'Content',
    'url' => 'content'
    ]
]
])

@section('content-admin')
<div class="row">
    <div class="col-lg-12">
        <div class="card alert">
            <form action="#" method="get">
                <div class="row">
                    <div class="col-md-3">
                        <div class="basic-form">
                            <div class="form-group">
                                <label>Title</label>
                                <input name="title" type="text" class="form-control border-none input-flat bg-ash">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="basic-form">
                            <div class="form-group">
                                <label>kategori</label>
                                <input name='kategori' type="text" class="form-control border-none input-flat bg-ash">
                            </div>
                        </div>
                    </div>
                    {{-- <div class="col-md-3">
                        <div class="basic-form">
                            <div class="form-group">
                                <label>Type Content</label>
                                <select name="isPost" class="form-control bg-ash border-none">
                                    <option value="0">Artice</option>
                                    <option value="1">Post</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="basic-form">
                            <div class="form-group">
                                <label>Status</label>
                                <select name="status" class="form-control bg-ash border-none">
                                    <option value="published">Published</option>
                                    <option value="draft">Fraft</option>
                                </select>
                            </div>
                        </div>
                    </div> --}}
                </div>
                <button class="btn btn-default btn-lg m-b-10 bg-warning border-none m-r-5 sbmt-btn" type="submit">Search</button>
                <a href="{{route('admin.content.index')}}" class="btn btn-default btn-lg m-b-10 bg-secondary border-none m-r-5 sbmt-btn" type="button">Reset</a>
            </form>
        </div>
    </div>
</div>
<div class="row">
    <!-- /# column -->
    <div class="col-lg-12">
        <div class="card alert">
            <div class="card-header">
                <h4>Content List </h4>
                <div class="card-header-right-icon">
                    <ul>
                        <li class=""><a href="#search"><i class="ti-search"></i></a></li>
                        <li class="doc-add"><a href="{{route('admin.content.create')}}"><i class="ti-plus"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Kategori</th>
                                <th>Title</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Author</th>
                                <th class="text-center" style="width:10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($contents as $content)
                            <tr>
                                <td scope="row">{{$contents->firstItem() + $loop->index}}</td>
                                <td>{{$content->kategori}}</td>
                                <td>{{$content->title}}</td>
                                @if($content->status == 'draft')
                                <td><span class="badge badge-danger">{{$content->status}}</span></td>
                                @else
                                <td><span class="badge badge-primary">{{$content->status}}</span></td>
                                @endif
                                <td>{{$content->created_at}}</td>
                                <td class="color-primary">{{$content->user->name}}</td>
                                <td>
                                    <a href="{{route('admin.content.edit',$content->id)}}"><i class="ti-pencil"
                                            data-toggle="tooltip" data-placement="top" title="Edit Content"></i></a>
                                    <a href="" onclick="event.preventDefault();
                                                  document.getElementById('destroy-form{{$content->id}}').submit();"
                                        data-toggle="tooltip" data-placement="top" title="Delete Content">
                                        <i class="ti-trash"></i>
                                    </a>
                                    <a href="{{route('admin.content.show',$content->id)}}"><i class="ti-eye"
                                            data-toggle="tooltip" data-placement="top" title="View Comment"></i></a>
                                    <form class="d-none" id="destroy-form{{$content->id}}"
                                        action="{{route('admin.content.destroy',$content->id)}}" method="POST">
                                        @method("DELETE")
                                        @csrf
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    {{$contents->links('pagination::bootstrap-4')}}
                </div>
            </div>
        </div>
        <!-- /# card -->
    </div>
    <!-- /# column -->

</div>

@endsection
