<?php

namespace App\Http\Controllers;

use App\Models\Content;
use App\Models\Quiz;
use App\Models\Score;
use App\Models\User;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $data['user'] =  count(User::withWhereHas('roles', function ($q) {
            $q->where('name', 'user');
        })->get());

        $data['content'] = count(Content::where('status', 'published')->where('isPost', 0)->get());
        $data['post'] = count(Content::where('status', 'published')->where('isPost', 1)->get());
        $data['quiz'] = count(Quiz::where('is_active', 1)->get());
        return view('admin.home', compact('data'));
    }

    public function indexuser()
    {
        $data['user'] = User::with('roles')->find(auth()->user()->id);
        $data['content'] = count(Content::where('status', 'published')->where('isPost', 0)->where('user_id', auth()->user()->id)->get());
        $data['post'] = count(Content::where('status', 'published')->where('isPost', 1)->where('user_id', auth()->user()->id)->get());
        $data['quiz'] = count(Score::where('user_id', auth()->user()->id)->get());

        return view('user.home', compact('data'));
    }
}
